src/
├── config/
│   ├── index.js            # General configuration (e.g., environment variables)
│   └── database.js         # Database connection settings
├── controllers/            # Handle HTTP requests and responses
│   ├── authController.js
│   ├── userController.js
│   ├── inventoryController.js
│   ├── salesController.js
│   └── ...                 # Other feature-specific controllers
├── middleware/             # Reusable middleware functions
│   ├── authMiddleware.js   # Authentication and authorization logic
│   ├── errorMiddleware.js  # Centralized error handling
│   ├── validationMiddleware.js # Input validation
│   └── ...                 # Other middleware (e.g., logging)
├── models/                 # Sequelize models for database tables
│   ├── user.js
│   ├── inventoryItem.js
│   ├── sale.js
│   └── ...                 # Other models based on your schema
├── routes/                 # API route definitions
│   ├── authRoutes.js
│   ├── userRoutes.js
│   ├── inventoryRoutes.js
│   ├── salesRoutes.js
│   └── ...                 # Other feature-specific routes
├── services/               # Business logic and database operations
│   ├── authService.js
│   ├── userService.js
│   ├── inventoryService.js
│   ├── salesService.js
│   └── ...                 # Other services for specific features
├── utils/                  # Helper functions and utilities
│   ├── logger.js           # Logging utility
│   ├── helpers.js          # General helper functions (e.g., date formatting)
│   └── ...                 # Other utilities
├── reports/                # Report generation and file handling
│   ├── reportGenerator.js  # Logic for generating reports
│   ├── pdfGenerator.js     # PDF export functionality
│   ├── excelGenerator.js   # Excel export functionality
│   └── ...                 # Other report-related modules
├── app.js                  # Express app setup (middleware, routes)
└── server.js               # Server startup script