const { PrismaClient } = require('@prisma/client');
const { hashPassword } = require('../src/utils/password');

const prisma = new PrismaClient();

const seedAdmins = async () => {
  try {
    // Delete existing data if needed
    await prisma.user.deleteMany();
    await prisma.location.deleteMany();

    // Create HQ location first
    const hqLocation = await prisma.location.create({
      data: {
        name: 'Headquarters',
        type: 'HQ',
        address: 'Dodoma',
        contactPhone: '+255653533585',
        contactEmail: 'hq@amigo.com',
        isActive: true
      }
    });

    // Create super admin user
    const hashedPassword = await hashPassword('amigoKings');
    await prisma.user.upsert({
      where: { username: 'admin' },
      update: {},
      create: {
        username: 'admin',
        passwordHash: hashedPassword,
        fullName: 'System Administrator',
        email: 'admin@amigo.com',
        phone: '+255653533585',
        locationId: hqLocation.id,
        userRole: 'ADMIN',
        isActive: true
      }
    });

    console.log('✅ Seed data inserted successfully');
    await prisma.$disconnect();
  } catch (error) {
    console.error('❌ Error seeding data:', error);
    await prisma.$disconnect();
    process.exit(1);
  }
};

seedAdmins();
