const { body, param } = require('express-validator');
const { validateRequest } = require('./validationMiddleware');

const validateCreateCategory = [
  body('name')
    .trim()
    .notEmpty()
    .withMessage('Category name is required')
    .isLength({ max: 100 })
    .withMessage('Category name must be at most 100 characters'),

  body('description')
    .optional()
    .trim(),

  validateRequest
];

const validateUpdateCategory = [
  param('id')
    .isInt()
    .withMessage('Invalid category ID'),

  ...validateCreateCategory
];

module.exports = {
  validateCreateCategory,
  validateUpdateCategory
};
