const express = require('express');
const router = express.Router();
const { authenticate, authorizeAdmin } = require('../middleware/authMiddleware');
const { validateLogin, validateRegistration, validateUserApproval } = require('../middleware/authValidation');
const authController = require('../controllers/authController');

// Public routes
router.post('/login', validateLogin, authController.login);
router.post('/register', validateRegistration, authController.register);

// Protected routes
router.get('/profile', authenticate, authController.getProfile);

// Admin routes for user approval
router.get('/pending-users', authenticate, authorizeAdmin, authController.getPendingUsers);
router.post('/approve-user', authenticate, authorizeAdmin, validateUserApproval, authController.approveUser);

module.exports = router;
